\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{thesisclass}[2022/01/28 Thesis LaTeX class by @aliwimo]
% ------------------------------------------------------------------------------------------ %
% template class
\LoadClass[12pt, a4paper, oneside]{book}
% ------------------------------------------------------------------------------------------ %
% required packages
\usepackage[a4paper, left=4cm, right=2.5cm, top=2.5cm, bottom=1.5cm, includefoot]{geometry}
\usepackage{lipsum}
\usepackage{newtxtext, newtxmath}
\usepackage{algorithm, algpseudocode}
\usepackage{algorithmicx}
\usepackage{titlesec}
\usepackage{graphicx}
\usepackage[makeroom]{cancel}
\usepackage{placeins}
\usepackage{xcolor}
\usepackage{multirow}
\usepackage{amsmath}
\usepackage{tabularx}
\usepackage{etoolbox} 
\usepackage{rotating}
\usepackage{bbding,pifont,utfsym,fontawesome}
\newcommand{\cmark}{\ding{51}}%
\newcommand{\xmark}{\ding{55}}%
\newtheorem{definition}{Definition}
\newtheorem{lemma}{Lemma}
\newtheorem{refproof}{Proof}
\renewcommand{\therefproof}{\arabic{chapter}.\arabic{refproof}}
\counterwithin{definition}{chapter}
\renewcommand{\thedefinition}{\arabic{chapter}.\arabic{definition}}
\newtheorem{theorem}{Theorem}
\counterwithin{theorem}{chapter}
\renewcommand{\thetheorem}{\arabic{chapter}.\arabic{theorem}}
\newtheorem{remark}{Remark}
\usepackage{tikz}
\newcommand*\circled[1]{\tikz[baseline=(char.base)]{
		\node[shape=circle,draw,inner sep=2pt] (char) {#1};}}
    \usepackage{algorithm}
\def\NoNumber#1{{\def\alglinenumber##1{}\State #1}\addtocounter{ALG@line}{-1}}
\usepackage{color,soul}
\newcommand{\dblprime}{^{\prime\prime}}


% ------------------------------------------------------------------------------------------ %
% to patch and remove the extra space after figures list for each chapter
% must be used before hyperref package
\makeatletter
\patchcmd{\@chapter}{\addtocontents{lof}{\protect\addvspace{10\p@}}}{}{}{}
\patchcmd{\@chapter}{\addtocontents{lot}{\protect\addvspace{10\p@}}}{}{}{}
\makeatother
% ------------------------------------------------------------------------------------------ %
%\usepackage[hidelinks,colorlinks=true,linkcolor=red,citecolor=blue]{hyperref}
\usepackage{hyperref}
\usepackage{cleveref}
\usepackage[notocbib]{apacite}
\usepackage{fancyhdr}
\usepackage{setspace}
\usepackage{mfirstuc}
\usepackage{tocloft}
\usepackage{caption}
\usepackage{booktabs}
\usepackage{longtable}
\usepackage[para]{threeparttable} % for table notes
\usepackage{enumitem}
\usepackage{subfig}
\usepackage{indentfirst} % to force indent first paragraphes
\usepackage{afterpage}
% ------------------------------------------------------------------------------------------ %
% to include empty page and the following lines is for its options
\newcommand\blankpage{
  \null
  \thispagestyle{empty} %
  \addtocounter{page}{-1} %
  \newpage
}
% ------------------------------------------------------------------------------------------ %
% customizing content of table
% set depth in TOC
% 0 for chapters
% 1 for chapters, and sections
% 2 for chapters, sections, and subsections
% 3 for chapters, sections, subsections, and subsubsections
\setcounter{tocdepth}{3}
% to number subsubsections
\setcounter{secnumdepth}{5}
% make chapter titles in table of content uppercase
\makeatletter
\let\oldcontentsline\contentsline
\def\contentsline#1#2{%
  \expandafter\ifx\csname l@#1\endcsname\l@chapter
    \expandafter\@firstoftwo
  \else
    \expandafter\@secondoftwo
  \fi
  {%
    \oldcontentsline{#1}{\MakeUppercase{#2}}%
  }{%
    \oldcontentsline{#1}{#2}%
  }%
}
\makeatother
% define the width between dots in list tables, figures, and contents
\def \dotsepwidth {0.5}
\def \toclinemargin {6pt}
% make new custem list for custom pages (2 lines)
\newcommand{\listofcustom}{Custom Pages}
\newlistof{custom}{def}{\listofcustom} 
\renewcommand{\cftcustomfont}{\normalfont\bfseries} % customize font
% \renewcommand{\cftcustomfont}{\normalfont\bfseries} % customize font
\renewcommand{\cftcustomdotsep}{\dotsepwidth} % add dots leader
% customizing table of contents
\renewcommand{\contentsname}{İÇİNDEKİLER} % uppercase title
\renewcommand{\cfttoctitlefont}{\hfill\bfseries\large} % center title and make it bold
\renewcommand{\cftaftertoctitle}{\hfill} % center title
\setlength{\cftbeforetoctitleskip}{0pt} % space before title
\setlength{\cftaftertoctitleskip}{18pt} % space after title
% part lines
\renewcommand{\cftpartfont}{\normalfont} % customize font
\renewcommand{\cftpartpagefont}{\normalfont} % customize page number font
\renewcommand{\cftpartdotsep}{\dotsepwidth} % add dots leader
\setlength{\cftbeforepartskip}{0pt} % remove skip before line
% \renewcommand{\cftpartafterpnum}{\vspace{\toclinemargin}} % add 6pt after each record
% chapter lines
\renewcommand{\cftchapfont}{\normalfont\bfseries} % customize font
\renewcommand{\cftchapdotsep}{\dotsepwidth} % add dots leader
\setlength{\cftbeforechapskip}{0em} % remove skip before line
\setlength{\cftchapnumwidth}{1em} % width of number area
\setlength{\cftchapindent}{0pt} % indent text
% \renewcommand{\cftchapafterpnum}{\vspace{\toclinemargin}} % add 6pt after each record
% section lines
\renewcommand{\cftsecdotsep}{\dotsepwidth} % add dots leader
\setlength{\cftsecnumwidth}{1.8em} % width of number area
\setlength{\cftsecindent}{12pt} % indent text
% \renewcommand{\cftsecafterpnum}{\vspace{\toclinemargin}} % add 6pt after each record
% sub-section lines
\renewcommand{\cftsubsecdotsep}{\dotsepwidth} % add dots leader
\setlength{\cftsubsecnumwidth}{2.5em} % width of number area
\setlength{\cftsubsecindent}{28pt} % indent text
% \renewcommand{\cftsubsecafterpnum}{\vspace{\toclinemargin}} % add 6pt after each record
% sub-sub-section lines
\renewcommand{\cftsubsubsecdotsep}{\dotsepwidth} % add dots leader
\setlength{\cftsubsubsecnumwidth}{3.2em} % width of number area
\setlength{\cftsubsubsecindent}{52pt} % indent text
% \renewcommand{\cftsubsubsecafterpnum}{\vspace{\toclinemargin}} % add 6pt after each record
% ------------------------------------------------------------------------------------------ %
% customizing list of figures
\renewcommand{\listfigurename}{ŞEKİLLER DİZİNİ} % uppercase title
\renewcommand{\cftloftitlefont}{\hspace*{\fill}\bfseries\large} % center title and make it bold
\renewcommand{\cftafterloftitle}{\hspace*{\fill}} % center title
\setlength{\cftbeforeloftitleskip}{0pt} % space before title
\setlength{\cftafterloftitleskip}{18pt} % space after title
\renewcommand{\cftfigpresnum}{Şekil } % put custom word before the number
\renewcommand{\cftfigaftersnum}{.} % put custom word after the number
\renewcommand{\cftfigdotsep}{\dotsepwidth} % add dots leader
\renewcommand{\cftfigafterpnum}{\vspace{6pt}} % add 6pt after each record
\setlength{\cftfignumwidth}{5em} % width of number area
\setlength{\cftfigindent}{0em} % indent text
% ------------------------------------------------------------------------------------------ %
% customizing list of tables
\renewcommand{\listtablename}{TABLOLAR DİZİNİ} % uppercase title
\renewcommand{\cftlottitlefont}{\hspace*{\fill}\bfseries\large} % center title and make it bold
\renewcommand{\cftafterlottitle}{\hspace*{\fill}} % center title
\setlength{\cftbeforelottitleskip}{0pt} % space before title
\setlength{\cftafterlottitleskip}{18pt} % space after title
\renewcommand{\cfttabpresnum}{Tablo } % put custom word before the number
\renewcommand{\cfttabaftersnum}{.} % put custom word after the number
\renewcommand{\cfttabdotsep}{\dotsepwidth} % add dots leader
\renewcommand{\cfttabafterpnum}{\vspace{6pt}} % add 6pt after each record
\setlength{\cfttabnumwidth}{4.5em} % width of number area
\setlength{\cfttabindent}{0em} % indent text
% ------------------------------------------------------------------------------------------ %
% heyperlinks setting





% ------------------------------------------------------------------------------------------ %   
% custom page style
\pagestyle{fancy}
\fancyhf{}
\renewcommand{\headrulewidth}{0pt}
\cfoot{\thepage}
% ------------------------------------------------------------------------------------------ %
% for more details see caption package documentation
% number equations, figures, and tables according to chapters
% equations
\counterwithin{equation}{chapter}
\renewcommand{\theequation}{\arabic{chapter}.\arabic{equation}}
% figures
\counterwithin{figure}{chapter}
\renewcommand{\thefigure}{\arabic{chapter}.\arabic{figure}} % set caption label style to 1.A
\captionsetup[figure]{format=hang,labelsep=period,name={Şekil},skip=12pt,parskip=0pt,justification=justified,font=small}
% tables
\counterwithin{table}{chapter}
\renewcommand{\thetable}{\arabic{chapter}.\arabic{table}} % set caption label style to 1.A
% \captionsetup[table]{format=hang,labelsep=period,name={Table},skip=12pt,parskip=12pt,singlelinecheck=off,justification=justified,font=small}
\captionsetup[table]{format=hang,labelsep=period,name={Tablo},skip=12pt,parskip=12pt,singlelinecheck=off,justification=justified,font=small}
% ------------------------------------------------------------------------------------------ %
% set main skips and stretches and main variables
\linespread{1.5}
\setlength\floatsep{12pt}
\setlength\textfloatsep{18pt}
\setlength\intextsep{18pt}
\setlength\parskip{6pt}
\setlength\parindent{1cm}
\newlength{\indenttitles}
\setlength{\indenttitles}{1cm}
% \def\aftertable{-24pt}
\def\aftertable{0pt}
% \AfterEndEnvironment{tablenotes}{\kern-12pt}
% \BeforeBeginEnvironment{figure}{\kern 12pt}
% \AfterEndEnvironment{figure}{\kern-6pt}
% \BeforeBeginEnvironment{table}{\kern 6pt}
% \AfterEndEnvironment{table}{\kern-12pt}
% ------------------------------------------------------------------------------------------ %
% force top place figures and tables if the page is empty
\makeatletter
    \setlength\@fptop{0\p@}
\makeatother
% ------------------------------------------------------------------------------------------ %
% center chapter titles and style sub title styles:
% remember: for 12pt book documents:
% \tiny           6pt
% \scriptsize     8pt
% \footnotesize   10pt
% \small          11pt
% \normalsize     12pt
% \large          14pt
% \Large          17pt
% \LARGE          20pt
% \huge           25pt
% \Huge           30pt
\def \ChapterTitlePosition {left}
\ifdefstring{\ChapterTitlePosition}{center}
{% true:
  \titleformat{\chapter}[block]{\fontsize{14}{14}\bfseries\centering}{\centering\thechapter}{0.5em}{\normalfont\bfseries\uppercase}[]
}{ % false:
  \titleformat{\chapter}{\fontsize{14}{12}\bfseries\uppercase}{\thechapter}{0.5em}{}
}
\titleformat{\section}{\normalfont\bfseries}{\thesection}{0.5em}{}
\titleformat{\subsection}{\normalfont\bfseries}{\thesubsection}{0.5em}{}
\titleformat{\subsubsection}{\normalfont\bfseries}{\thesubsubsection}{0.5em}{}
\titleformat{\paragraph}{\normalfont\bfseries}{\theparagraph}{0.5em}{}
\titleformat{\subparagraph}{\normalfont\bfseries}{\thesubparagraph}{0.5em}{}
% ------------------------------------------------------------------------------------------ %
% set margins of the titles
% \titlespacing{command}{left spacing}{before spacing}{after spacing}[right]
\titlespacing\chapter{\indenttitles}{6pt}{6pt}
\titlespacing\section{\indenttitles}{6pt}{6pt}
\titlespacing\subsection{\indenttitles}{6pt}{6pt}
\titlespacing\subsubsection{\indenttitles}{6pt}{6pt}
\titlespacing\paragraph{\indenttitles}{6pt}{6pt}
\titlespacing\subparagraph{\indenttitles}{6pt}{6pt}
% ------------------------------------------------------------------------------------------ %
% reformat some commands değişiklik yapıldı
\renewcommand{\thechapter}{\arabic{chapter}.}
\renewcommand{\thesection}{\thechapter\arabic{section}.} 
\renewcommand{\thesubsection}{\thesection\arabic{subsection}.}
\renewcommand{\thesubsubsection}{\thesubsection\arabic{subsubsection}.}
\renewcommand{\theparagraph}{\thesubsubsection\arabic{paragraph}.}
\renewcommand{\thesubparagraph}{\theparagraph\arabic{subparagraph}.}
% ------------------------------------------------------------------------------------------ %

% ------------------------------------------------------------------------------------------ %
% create new environment for custom pages
\newenvironment{custom}[1]
{
\vspace*{0pt}
\begin{center}
\fontsize{14}{14}\bfseries{\uppercase{#1}}
\end{center}
}{}
% ------------------------------------------------------------------------------------------ %
% rename the word of each element when used with \autoref command
\renewcommand{\chapterautorefname}{Chapter}
\renewcommand{\sectionautorefname}{Section}
\renewcommand{\subsectionautorefname}{Subsection}
\renewcommand{\subsubsectionautorefname}{Subsection}
\renewcommand{\equationautorefname}{Eq.}
\newcommand{\algorithmautorefname}{Alg.}
\renewcommand{\figureautorefname}{Şekil }
\renewcommand{\tableautorefname}{Tablo }
% ------------------------------------------------------------------------------------------ %
% remove chapter's first page number 
%\makeatletter
%\renewcommand\chapter{\if@openright\cleardoublepage\else\clearpage\fi
%\thispagestyle{empty}%
%\global\@topnum\z@
%\@afterindentfalse
%\secdef\@chapter\@schapter}
%\makeatother
% ------------------------------------------------------------------------------------------ %
% style lists and remove its left margin
\setitemize{itemsep=-6pt, leftmargin=*, topsep=0pt}
% \setitemize{itemsep=-6pt, topsep=0pt}
% ------------------------------------------------------------------------------------------ %
% prevent LaTeX from hyphenating the entire document
\usepackage[none]{hyphenat}
\tolerance=1
\emergencystretch=\maxdimen
\hyphenpenalty=10000
\hbadness=10000